'use client';

import React from 'react';
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
} from '@/components/ui/dialog';
import { MeasurementForm, type MeasurementFormValues } from './measurement-form';
import type { CustomerMeasurement, TailoringItem } from '@/lib/data';

type MeasurementDialogProps = {
  isOpen: boolean;
  onOpenChange: (isOpen: boolean) => void;
  measurement: CustomerMeasurement | null;
  onSubmit: (data: MeasurementFormValues) => void;
  tailoringItems: TailoringItem[];
};

export function MeasurementDialog({ isOpen, onOpenChange, measurement, onSubmit, tailoringItems }: MeasurementDialogProps) {
  const isEditMode = !!measurement;

  return (
    <Dialog open={isOpen} onOpenChange={onOpenChange}>
      <DialogContent className="sm:max-w-md">
        <DialogHeader>
          <DialogTitle>{isEditMode ? 'Edit Measurement' : 'Add New Measurement'}</DialogTitle>
          <DialogDescription>
            {isEditMode ? 'Update the details for this item.' : 'Enter the item name and its measurements.'}
          </DialogDescription>
        </DialogHeader>
        <MeasurementForm
          key={measurement?.id || 'new-measurement'}
          measurement={measurement}
          onSubmit={(data) => {
            onSubmit(data);
            onOpenChange(false); 
          }}
          tailoringItems={tailoringItems}
        />
      </DialogContent>
    </Dialog>
  );
}
