'use client';

import React from 'react';
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
} from '@/components/ui/dialog';
import { EmployeeForm, type EmployeeFormValues } from './employee-form';
import type { Employee } from '@/lib/data';

type EmployeeDialogProps = {
  isOpen: boolean;
  onOpenChange: (isOpen: boolean) => void;
  employee: Employee | null;
  onSubmit: (data: EmployeeFormValues) => void;
};

export function EmployeeDialog({ isOpen, onOpenChange, employee, onSubmit }: EmployeeDialogProps) {
  const isEditMode = !!employee;

  return (
    <Dialog open={isOpen} onOpenChange={onOpenChange}>
      <DialogContent className="sm:max-w-[425px]">
        <DialogHeader>
          <DialogTitle>{isEditMode ? 'Edit Employee' : 'Add New Employee'}</DialogTitle>
          <DialogDescription>
            {isEditMode ? 'Update the details of this employee.' : 'Enter the details to add a new employee.'}
          </DialogDescription>
        </DialogHeader>
        <EmployeeForm
          key={employee?.id || 'new-employee'}
          employee={employee}
          onSubmit={(data) => {
            onSubmit(data);
            onOpenChange(false); 
          }}
        />
      </DialogContent>
    </Dialog>
  );
}
