'use client';

import React from 'react';
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
} from '@/components/ui/dialog';
import { AddIncomeForm, type TransactionFormValues } from './add-income-form';
import type { Transaction } from '@/lib/data';

type AddIncomeDialogProps = {
  isOpen: boolean;
  onOpenChange: (isOpen: boolean) => void;
  income: Transaction | null;
  onSubmit: (income: TransactionFormValues) => void;
};

export function AddIncomeDialog({ isOpen, onOpenChange, income, onSubmit }: AddIncomeDialogProps) {
  const isEditMode = !!income;

  return (
    <Dialog open={isOpen} onOpenChange={onOpenChange}>
      <DialogContent className="sm:max-w-[425px]">
        <DialogHeader>
          <DialogTitle>{isEditMode ? 'Edit Income' : 'Add New Income'}</DialogTitle>
          <DialogDescription>
            {isEditMode
              ? 'Update the details of this income record.'
              : 'Enter the details below to add a new income transaction.'}
          </DialogDescription>
        </DialogHeader>
        <AddIncomeForm
          key={income?.id || 'new-income'}
          income={income}
          onSubmit={(data) => {
            onSubmit(data);
            onOpenChange(false); 
          }}
        />
      </DialogContent>
    </Dialog>
  );
}
