// Main database module exports
export * from './types';
export * from './schema';
export * from './service';
export * from './migration';

// Re-export Firebase utilities
export { db, auth, storage } from '../firebase';

// Convenience exports for commonly used services
export {
  shopService,
  userService,
  customerService,
  customerMeasurementService,
  inventoryService,
  tailoringItemService,
  employeeService,
  orderService,
  incomeTransactionService,
  expenseTransactionService,
  appearanceSettingsService,
  notificationSettingsService,
  auditLogService,
  reportDataService,
  customerServiceExtended,
  orderServiceExtended,
  inventoryServiceExtended,
  dbUtils,
} from './service';

// Migration utilities
export {
  DataMigration,
  runMigration,
  checkAndRunMigration,
} from './migration';

// Database initialization and setup
export { initializeDatabase } from './setup';
