# **App Name**: Textile Manager

## Core Features:

- Income Logging: Log daily income with categories (cash, card, etc.).
- Expense Logging: Log monthly expenses (rent, utilities, salaries, etc.).
- Customer Order Management: Record customer orders, track their status (pending, in progress, completed) and delivery dates.
- Profit Calculation Tool: An AI-powered tool that calculates the net profit and profit margins based on logged income and expenses. It presents potential optimization opportunities, helping you manage and minimize cost
- Dashboard Overview: Display a summary of income, expenses, orders, and profit for a quick overview.
- User Authentication: Provide login, logout, and password reset functionality.
- Report Generation: Generate monthly or custom date range reports for income and expenses.

## Style Guidelines:

- Background color: Light desaturated gray (#f0f2f5) to ensure a comfortable viewing experience and contrast for text and elements.
- Primary color: A calm teal (#468499) to promote a sense of trust and efficiency.
- Accent color: Use a warm, vibrant gold (#d4af37) to draw attention to key actions, new functions and success metrics in profit calculation charts and order summary.
- Font pairing: Use 'Poppins' (sans-serif) for headlines to maintain modernity, paired with 'PT Sans' (sans-serif) for body text to maintain readability.
- Design a responsive layout that adapts to different screen sizes, ensuring a seamless experience on desktop and mobile devices.
- Employ clear and intuitive icons to represent various functions, enhancing user understanding and streamlining navigation.
- Implement subtle transition effects to signal data processing and the creation of visual information on screen