'use client';

import { PageHeader } from "@/components/page-header";
import {
  Tabs,
  TabsContent,
  TabsList,
  TabsTrigger,
} from "@/components/ui/tabs";
import { ProfileForm } from "@/components/settings/profile-form";
import { ServicesForm } from "@/components/settings/services-form";
import { AppearanceForm } from "@/components/settings/appearance-form";
import { NotificationsForm } from "@/components/settings/notifications-form";

export default function SettingsPage() {
  return (
    <div className="flex flex-col gap-4">
        <PageHeader title="Settings" />
        <Tabs defaultValue="profile" className="space-y-4">
            <TabsList>
                <TabsTrigger value="profile">Profile & Security</TabsTrigger>
                <TabsTrigger value="services">Services</TabsTrigger>
                <TabsTrigger value="appearance">Appearance</TabsTrigger>
                <TabsTrigger value="notifications">Notifications</TabsTrigger>
            </TabsList>
            <TabsContent value="profile" className="space-y-4">
                <ProfileForm />
            </TabsContent>
            <TabsContent value="services" className="space-y-4">
                <ServicesForm />
            </TabsContent>
            <TabsContent value="appearance" className="space-y-4">
                <AppearanceForm />
            </TabsContent>
            <TabsContent value="notifications" className="space-y-4">
                <NotificationsForm />
            </TabsContent>
        </Tabs>
    </div>
  )
}
