'use client';

import React from 'react';
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
} from '@/components/ui/dialog';
import { AddCustomerForm } from './add-customer-form';
import type { Customer } from '@/lib/data';

type AddCustomerDialogProps = {
  isOpen: boolean;
  onOpenChange: (isOpen: boolean) => void;
  onCustomerAdd: (customer: Omit<Customer, 'id' | 'totalOrders' | 'totalSpent'>) => void;
};

export function AddCustomerDialog({ isOpen, onOpenChange, onCustomerAdd }: AddCustomerDialogProps) {
  return (
    <Dialog open={isOpen} onOpenChange={onOpenChange}>
      <DialogContent className="sm:max-w-[425px]">
        <DialogHeader>
          <DialogTitle>Add New Customer</DialogTitle>
          <DialogDescription>
            Enter the details below to add a new customer.
          </DialogDescription>
        </DialogHeader>
        <AddCustomerForm
          onSubmit={(data) => {
            onCustomerAdd(data);
            onOpenChange(false); 
          }}
        />
      </DialogContent>
    </Dialog>
  );
}
