'use client';

import React from 'react';
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
} from '@/components/ui/dialog';
import { AddExpenseForm, type ExpenseFormValues } from './add-expense-form';
import type { Employee, Expense } from '@/lib/data';

type AddExpenseDialogProps = {
  isOpen: boolean;
  onOpenChange: (isOpen: boolean) => void;
  expense: Expense | null;
  onSubmit: (data: ExpenseFormValues) => void;
  employees: Employee[];
  defaultCategory?: string;
  defaultPerson?: string;
};

export function AddExpenseDialog({ isOpen, onOpenChange, expense, onSubmit, employees, defaultCategory, defaultPerson }: AddExpenseDialogProps) {
  const isEditMode = !!expense;

  return (
    <Dialog open={isOpen} onOpenChange={onOpenChange}>
      <DialogContent className="sm:max-w-[425px]">
        <DialogHeader>
          <DialogTitle>{isEditMode ? 'Edit Expense' : 'Add New Expense'}</DialogTitle>
          <DialogDescription>
            {isEditMode ? 'Update the details of this expense record.' : 'Enter the details to add a new expense.'}
          </DialogDescription>
        </DialogHeader>
        <AddExpenseForm
          key={expense?.id || 'new-expense'}
          expense={expense}
          employees={employees}
          onSubmit={(data) => {
            onSubmit(data);
            onOpenChange(false);
          }}
          defaultCategory={defaultCategory}
          defaultPerson={defaultPerson}
        />
      </DialogContent>
    </Dialog>
  );
}
