
'use client';

import React from 'react';
import Barcode from 'react-barcode';
import {
  Dialog,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogFooter,
  DialogDescription,
} from '@/components/ui/dialog';
import { Button } from '@/components/ui/button';
import type { InventoryItem } from '@/lib/data';

type BarcodeDialogProps = {
  isOpen: boolean;
  onOpenChange: (isOpen: boolean) => void;
  item: InventoryItem;
};

export function BarcodeDialog({ isOpen, onOpenChange, item }: BarcodeDialogProps) {
  
  const handlePrint = () => {
    const printContent = document.getElementById('barcode-section');
    const windowUrl = 'about:blank';
    const uniqueName = new Date();
    const windowName = 'Print' + uniqueName.getTime();
    const printWindow = window.open(windowUrl, windowName, 'left=50000,top=50000,width=0,height=0');

    if (printWindow && printContent) {
        printWindow.document.write('<html><head><title>Print Barcode</title>');
        printWindow.document.write('<style>@media print { body { -webkit-print-color-adjust: exact; } @page { size: 2.25in 1.25in; margin: 0; } body { margin: 0; display: flex; justify-content: center; align-items: center; text-align: center; } .barcode-container { display: flex; flex-direction: column; align-items: center; justify-content: center; width: 100%; height: 100%; } svg { max-width: 100%; height: auto; } .item-name { font-size: 10px; font-family: sans-serif; margin-top: 4px; } }</style>');
        printWindow.document.write('</head><body>');
        printWindow.document.write('<div class="barcode-container">');
        printWindow.document.write(printContent.innerHTML);
        printWindow.document.write('</div></body></html>');
        printWindow.document.close();
        printWindow.focus();
        printWindow.print();
        printWindow.close();
    }
  };


  return (
    <Dialog open={isOpen} onOpenChange={onOpenChange}>
      <DialogContent className="sm:max-w-md">
        <DialogHeader>
          <DialogTitle>Print Barcode</DialogTitle>
          <DialogDescription>
            Print a barcode for the item: <strong>{item.name}</strong>
          </DialogDescription>
        </DialogHeader>
        <div id="barcode-section" className="flex flex-col items-center justify-center p-4">
          <Barcode 
            value={item.id} 
            width={1.5}
            height={50}
            fontSize={12}
            margin={10}
            />
          <p className="item-name mt-2 text-xs font-semibold">{item.name}</p>
        </div>
        <DialogFooter>
          <Button type="button" variant="outline" onClick={() => onOpenChange(false)}>
            Cancel
          </Button>
          <Button onClick={handlePrint}>Print</Button>
        </DialogFooter>
      </DialogContent>
    </Dialog>
  );
}

