
'use client';

import React from 'react';
import Barcode from 'react-barcode';
import {
  Dialog,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogFooter,
  DialogDescription,
} from '@/components/ui/dialog';
import { Button } from '@/components/ui/button';
import { ScrollArea } from '@/components/ui/scroll-area';
import type { InventoryItem } from '@/lib/data';

type BulkBarcodeDialogProps = {
  isOpen: boolean;
  onOpenChange: (isOpen: boolean) => void;
  items: InventoryItem[];
};

export function BulkBarcodeDialog({ isOpen, onOpenChange, items }: BulkBarcodeDialogProps) {
  
  const handlePrint = () => {
    const printContent = document.getElementById('bulk-barcode-section');
    const windowUrl = 'about:blank';
    const uniqueName = new Date();
    const windowName = 'Print' + uniqueName.getTime();
    const printWindow = window.open(windowUrl, windowName, 'left=50000,top=50000,width=0,height=0');

    if (printWindow && printContent) {
        printWindow.document.write('<html><head><title>Print Barcodes</title>');
        printWindow.document.write('<style>@media print { body { -webkit-print-color-adjust: exact; } @page { size: auto; margin: 10mm; } body { margin: 0; } .barcode-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(2.25in, 1fr)); gap: 10mm 5mm; } .barcode-item { display: flex; flex-direction: column; align-items: center; justify-content: center; page-break-inside: avoid; } svg { max-width: 100%; height: auto; } .item-name { font-size: 10px; font-family: sans-serif; margin-top: 4px; text-align: center; } }</style>');
        printWindow.document.write('</head><body><div class="barcode-grid">');
        printWindow.document.write(printContent.innerHTML);
        printWindow.document.write('</div></body></html>');
        printWindow.document.close();
        printWindow.focus();
        printWindow.print();
        printWindow.close();
    }
  };


  return (
    <Dialog open={isOpen} onOpenChange={onOpenChange}>
      <DialogContent className="sm:max-w-2xl">
        <DialogHeader>
          <DialogTitle>Print Barcodes</DialogTitle>
          <DialogDescription>
            Printing barcodes for {items.length} selected item(s).
          </DialogDescription>
        </DialogHeader>
        <ScrollArea className="h-96">
            <div id="bulk-barcode-section" className="p-4 grid grid-cols-2 gap-x-8 gap-y-12">
            {items.map(item => (
                <div key={item.id} className="barcode-item flex flex-col items-center justify-center">
                    <Barcode 
                        value={item.id} 
                        width={1.5}
                        height={50}
                        fontSize={12}
                        margin={10}
                    />
                    <p className="item-name mt-2 text-xs font-semibold text-center">{item.name}</p>
                </div>
            ))}
            </div>
        </ScrollArea>
        <DialogFooter>
          <Button type="button" variant="outline" onClick={() => onOpenChange(false)}>
            Cancel
          </Button>
          <Button onClick={handlePrint}>Print</Button>
        </DialogFooter>
      </DialogContent>
    </Dialog>
  );
}
