'use client';

import React from 'react';
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
} from '@/components/ui/dialog';
import { InventoryForm, type InventoryFormValues } from './inventory-form';
import type { InventoryItem } from '@/lib/data';

type InventoryDialogProps = {
  isOpen: boolean;
  onOpenChange: (isOpen: boolean) => void;
  item: InventoryItem | null;
  onSubmit: (data: InventoryFormValues) => void;
};

export function InventoryDialog({ isOpen, onOpenChange, item, onSubmit }: InventoryDialogProps) {
  const isEditMode = !!item;

  return (
    <Dialog open={isOpen} onOpenChange={onOpenChange}>
      <DialogContent className="sm:max-w-md">
        <DialogHeader>
          <DialogTitle>{isEditMode ? 'Edit Material' : 'Add New Material'}</DialogTitle>
          <DialogDescription>
            {isEditMode ? 'Update the details for this material.' : 'Enter the details for the new material.'}
          </DialogDescription>
        </DialogHeader>
        <InventoryForm
          key={item?.id || 'new-item'}
          item={item}
          onSubmit={(data) => {
            onSubmit(data);
            onOpenChange(false);
          }}
        />
      </DialogContent>
    </Dialog>
  );
}
