'use client';

import React from 'react';
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
  DialogFooter
} from '@/components/ui/dialog';
import { ItemForm, type ItemFormValues } from './item-form';
import type { TailoringItem } from "@/lib/data";

type ItemDialogProps = {
  isOpen: boolean;
  onOpenChange: (isOpen: boolean) => void;
  item: TailoringItem | null;
  onSubmit: (data: ItemFormValues) => void;
};


export function ItemDialog({ isOpen, onOpenChange, item, onSubmit }: ItemDialogProps) {
    const isEditMode = !!item;

    const closeDialog = () => {
        onOpenChange(false);
    };

    return (
        <Dialog open={isOpen} onOpenChange={onOpenChange}>
            <DialogContent className="sm:max-w-[425px]">
                <DialogHeader>
                    <DialogTitle>{isEditMode ? 'Edit Item' : 'Add New Item'}</DialogTitle>
                    <DialogDescription>
                        {isEditMode ? 'Update the details of your item.' : 'Enter the details to add a new item.'}
                    </DialogDescription>
                </DialogHeader>
                 <ItemForm
                    key={item?.id || 'new-item'} // Re-render form on item change
                    item={item}
                    onSubmit={(data) => {
                        onSubmit(data);
                        closeDialog();
                    }}
                    onCancel={closeDialog}
                />
            </DialogContent>
        </Dialog>
    );
}
