'use client';

import { Scissors } from 'lucide-react';
import Link from 'next/link';
import { useState, useEffect } from 'react';
import { getShopProfile } from '@/lib/data';

export function Logo() {
  const [shopName, setShopName] = useState('Textile Manager');

  useEffect(() => {
    const updateShopName = () => {
        const profile = getShopProfile();
        if (profile && profile.shopName) {
            setShopName(profile.shopName);
        }
    };
    
    updateShopName(); // Initial load

    window.addEventListener('storage', updateShopName);

    return () => {
      window.removeEventListener('storage', updateShopName);
    };
  }, []);


  return (
    <Link href="/dashboard" className="flex items-center gap-2">
      <div className="p-2 bg-primary rounded-lg">
        <Scissors className="h-6 w-6 text-primary-foreground" />
      </div>
      <span className="text-lg font-headline font-semibold text-primary">
        {shopName}
      </span>
    </Link>
  );
}
