'use client';

import React from 'react';
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
} from '@/components/ui/dialog';
import { OrderForm } from './order-form';
import type { Order, Customer, Employee, TailoringItem } from '@/lib/data';

type OrderDialogProps = {
  isOpen: boolean;
  onOpenChange: (isOpen: boolean) => void;
  order?: Order | null;
  customers: Customer[];
  tailoringItems: TailoringItem[];
  artisans: Employee[];
  cuttingMasters: Employee[];
  onOrderSubmit: (data: Omit<Order, 'id' | 'date'>) => void;
};

export function OrderDialog({ isOpen, onOpenChange, order, customers, tailoringItems, artisans, cuttingMasters, onOrderSubmit }: OrderDialogProps) {
  const isEditMode = !!order;

  const handleSubmit = (data: Omit<Order, 'id' | 'date'>) => {
    onOrderSubmit(data);
    onOpenChange(false); // Close dialog on submit
  };

  return (
    <Dialog open={isOpen} onOpenChange={onOpenChange}>
      <DialogContent className="sm:max-w-2xl">
        <DialogHeader>
          <DialogTitle>{isEditMode ? 'Edit Order' : 'Create New Order'}</DialogTitle>
          <DialogDescription>
            {isEditMode 
              ? "Update the details for this order." 
              : "Enter the details below to create a new order."}
          </DialogDescription>
        </DialogHeader>
        <OrderForm
          key={order?.id || 'new'} // Re-mount form when order changes
          order={order}
          customers={customers}
          tailoringItems={tailoringItems}
          artisans={artisans}
          cuttingMasters={cuttingMasters}
          onSubmit={handleSubmit}
        />
      </DialogContent>
    </Dialog>
  );
}
