import React from "react";
import { Button } from "@/components/ui/button";
import { PlusCircle } from "lucide-react";

type PageHeaderProps = {
  title: string;
  actionButtonText?: string;
  onActionButtonClick?: () => void;
  children?: React.ReactNode;
};

export function PageHeader({ title, actionButtonText, onActionButtonClick, children }: PageHeaderProps) {
  return (
    <div className="flex flex-col sm:flex-row sm:items-center gap-4">
      <h1 className="text-lg font-semibold md:text-2xl font-headline flex-1 shrink-0">{title}</h1>
      <div className="flex items-center gap-2 flex-wrap ml-auto">
        {children}
        {actionButtonText && onActionButtonClick && (
          <Button onClick={onActionButtonClick} size="sm" className="h-8 gap-1">
            <PlusCircle className="h-3.5 w-3.5" />
            <span className="sr-only sm:not-sr-only sm:whitespace-nowrap">
              {actionButtonText}
            </span>
          </Button>
        )}
      </div>
    </div>
  );
}
