import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import type { ProfitCalculationOutput } from '@/ai/flows/profit-calculation';
import { Badge } from '@/components/ui/badge';
import { Sparkles } from 'lucide-react';

type ProfitResultCardProps = {
  result: ProfitCalculationOutput;
};

export function ProfitResultCard({ result }: ProfitResultCardProps) {
  const profitMarginColor = result.profitMargin > 20 ? 'text-green-600' : result.profitMargin > 10 ? 'text-yellow-600' : 'text-red-600';

  return (
    <Card>
      <CardHeader>
        <CardTitle className="font-headline">Calculation Result</CardTitle>
        <CardDescription>Here is the analysis of your profit.</CardDescription>
      </CardHeader>
      <CardContent className="space-y-6">
        <div className="grid grid-cols-1 sm:grid-cols-2 gap-4 text-center">
            <div className="p-4 bg-muted/50 rounded-lg">
                <p className="text-sm text-muted-foreground">Net Profit</p>
                <p className="text-2xl font-bold">৳{result.netProfit.toLocaleString()}</p>
            </div>
            <div className="p-4 bg-muted/50 rounded-lg">
                <p className="text-sm text-muted-foreground">Profit Margin</p>
                <p className={`text-2xl font-bold ${profitMarginColor}`}>{result.profitMargin.toFixed(2)}%</p>
            </div>
        </div>

        <div>
          <h3 className="text-lg font-semibold flex items-center gap-2 mb-2 font-headline">
            <Sparkles className="h-5 w-5 text-accent" />
            Optimization Suggestions
          </h3>
          <p className="text-sm text-muted-foreground whitespace-pre-wrap">{result.optimizationSuggestions}</p>
        </div>
      </CardContent>
    </Card>
  );
}
