'use client';

import * as React from 'react';
import { Check, Copy, Paintbrush } from 'lucide-react';

import { cn } from '@/lib/utils';
import { Button } from '@/components/ui/button';
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
  DialogTrigger,
} from '@/components/ui/dialog';
import { Label } from '@/components/ui/label';
import {
  Popover,
  PopoverContent,
  PopoverTrigger,
} from '@/components/ui/popover';
import { ThemeWrapper } from './theme-wrapper';

const themes = [
  { name: 'zinc', label: 'Zinc', color: 'hsl(240 5.9% 10%)' },
  { name: 'slate', label: 'Slate', color: 'hsl(215.4 16.3% 46.9%)' },
  { name: 'stone', label: 'Stone', color: 'hsl(25 5.3% 44.7%)' },
  { name: 'gray', label: 'Gray', color: 'hsl(220 8.9% 46.1%)' },
  { name: 'neutral', label: 'Neutral', color: 'hsl(0 0% 45.1%)' },
  { name: 'red', label: 'Red', color: 'hsl(0 72.2% 50.6%)' },
  { name: 'rose', label: 'Rose', color: 'hsl(346.8 77.2% 49.8%)' },
  { name: 'orange', label: 'Orange', color: 'hsl(24.6 95% 53.1%)' },
  { name: 'green', label: 'Green', color: 'hsl(142.1 76.2% 36.3%)' },
  { name: 'blue', label: 'Blue', color: 'hsl(221.2 83.2% 53.3%)' },
  { name: 'yellow', label: 'Yellow', color: 'hsl(47.9 95.8% 53.1%)' },
  { name: 'violet', label: 'Violet', color: 'hsl(262.1 83.3% 57.8%)' },
];

export function ThemeCustomizer() {
  const [config, setConfig] = React.useState({
    theme: 'zinc',
    radius: 0.5,
  });
  const [mounted, setMounted] = React.useState(false);

  React.useEffect(() => {
    setMounted(true);
  }, []);

  return (
    <div className="flex items-center space-x-2">
      <div className="flex items-center gap-2">
        <Label htmlFor="theme" className="text-sm font-normal">
          Theme
        </Label>
        <div className="flex flex-wrap gap-2">
          <Popover>
            <PopoverTrigger asChild>
              <Button
                variant={'outline'}
                id="theme"
                className={cn('w-[160px] justify-start')}
              >
                {themes.find((t) => t.name === config.theme)?.label ||
                  'Select Theme'}
              </Button>
            </PopoverTrigger>
            <PopoverContent className="w-screen-minus-8 p-2">
              <div className="grid grid-cols-5 gap-x-2 gap-y-2">
                {themes.map((theme) => (
                  <Button
                    key={theme.name}
                    variant={'ghost'}
                    className={cn(
                      'flex w-full items-center justify-start gap-x-2 text-xs',
                      config.theme === theme.name && 'border-2 border-primary'
                    )}
                    onClick={() => setConfig({ ...config, theme: theme.name })}
                  >
                    <span
                      className={cn(
                        'flex h-5 w-5 shrink-0 -translate-x-1 items-center justify-center rounded-full'
                      )}
                      style={{ backgroundColor: theme.color }}
                    >
                      {config.theme === theme.name && (
                        <Check className="h-4 w-4 text-white" />
                      )}
                    </span>
                    <span className="flex-1">{theme.label}</span>
                  </Button>
                ))}
              </div>
            </PopoverContent>
          </Popover>
        </div>
      </div>
      <div className="flex items-center gap-x-2">
        <Label htmlFor="radius" className="text-sm font-normal">
          Radius
        </Label>
        <div className="flex flex-wrap gap-2">
          {['0', '0.3', '0.5', '0.75', '1.0'].map((r) => (
            <Button
              key={r}
              variant={'outline'}
              className={cn(
                'h-8 w-8 rounded-full p-1 text-xs',
                config.radius === parseFloat(r) && 'border-2 border-primary'
              )}
              onClick={() => setConfig({ ...config, radius: parseFloat(r) })}
            >
              {r}
            </Button>
          ))}
        </div>
      </div>

      <Dialog>
        <DialogTrigger asChild>
          <Button variant={'outline'}>
            <Paintbrush className="mr-2 h-4 w-4" />
            Customize
          </Button>
        </DialogTrigger>
        <DialogContent className="sm:max-w-[680px]">
          <DialogHeader>
            <DialogTitle>Customize Theme</DialogTitle>
            <DialogDescription>
              Pick a style and color to customize the appearance of the app.
            </DialogDescription>
          </DialogHeader>
          <div className="py-4">
            <ThemeWrapper
              className="flex-col space-y-4"
              defaultTheme={config.theme}
            >
              <div className="flex items-center gap-x-4">
                <Label htmlFor="theme">Theme</Label>
                <div className="flex flex-wrap gap-2">
                  <Popover>
                    <PopoverTrigger asChild>
                      <Button
                        variant={'outline'}
                        id="theme"
                        className={cn('w-[160px] justify-start')}
                      >
                        {themes.find((t) => t.name === config.theme)?.label ||
                          'Select Theme'}
                      </Button>
                    </PopoverTrigger>
                    <PopoverContent className="w-screen-minus-8 p-2">
                      <div className="grid grid-cols-5 gap-x-2 gap-y-2">
                        {themes.map((theme) => (
                          <Button
                            key={theme.name}
                            variant={'ghost'}
                            className={cn(
                              'flex w-full items-center justify-start gap-x-2 text-xs',
                              config.theme === theme.name &&
                                'border-2 border-primary'
                            )}
                            onClick={() =>
                              setConfig({ ...config, theme: theme.name })
                            }
                          >
                            <span
                              className={cn(
                                'flex h-5 w-5 shrink-0 -translate-x-1 items-center justify-center rounded-full'
                              )}
                              style={{ backgroundColor: theme.color }}
                            >
                              {config.theme === theme.name && (
                                <Check className="h-4 w-4 text-white" />
                              )}
                            </span>
                            <span className="flex-1">{theme.label}</span>
                          </Button>
                        ))}
                      </div>
                    </PopoverContent>
                  </Popover>
                </div>
              </div>
              <div className="flex items-center gap-x-4">
                <Label htmlFor="radius">Radius</Label>
                <div className="flex flex-wrap gap-2">
                  {['0', '0.3', '0.5', '0.75', '1.0'].map((r) => (
                    <Button
                      key={r}
                      variant={'outline'}
                      className={cn(
                        'h-8 w-8 rounded-full p-1 text-xs',
                        config.radius === parseFloat(r) &&
                          'border-2 border-primary'
                      )}
                      onClick={() =>
                        setConfig({ ...config, radius: parseFloat(r) })
                      }
                    >
                      {r}
                    </Button>
                  ))}
                </div>
              </div>
            </ThemeWrapper>
          </div>
        </DialogContent>
      </Dialog>
    </div>
  );
}
