"use client"

import React from "react"
import { useTheme } from "next-themes"

import { cn } from "@/lib/utils"

export function ThemeWrapper({
  defaultTheme,
  children,
  className,
}: {
  defaultTheme?: string
  children: React.ReactNode
  className?: string
}) {
  const [mounted, setMounted] = React.useState(false)
  const { forcedTheme } = useTheme()

  React.useEffect(() => {
    setMounted(true)
  }, [])

  const theme = defaultTheme || "zinc"

  if (!mounted) {
    return (
      <div
        className={cn(
          "flex h-full items-center justify-center bg-background",
          className
        )}
      >
        ...
      </div>
    )
  }

  return (
    <div
      className={cn(
        `theme-${theme}`,
        "w-full",
        forcedTheme === "dark" ? "dark" : "",
        className
      )}
      style={
        {
          "--radius": "0.5rem",
        } as React.CSSProperties
      }
    >
      {children}
    </div>
  )
}
